package com.srtech.ludoclassic.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.view.WindowManager;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;

import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.srtech.ludoclassic.R;
import com.srtech.ludoclassic.utility.StaticVariables;

public class LudoMainActivity extends Activity {

    RelativeLayout btnMultiplayer,btnTwoplayer,btnVsCompTwoplayer,btnVsComputer;
    private AdView mAdView;
    private InterstitialAd mInterstitialAd;

    class C03801 implements OnClickListener {
        C03801() {
        }

        public void onClick(View v) {
            startActivity(new Intent(LudoMainActivity.this, LudoMultiplayerActivity.class));
            showInterstitialAd();
        }
    }

    class C03812 implements OnClickListener {
        C03812() {
        }

        public void onClick(View v) {
           startActivity(new Intent(LudoMainActivity.this, LudoVsCompActivity.class));
           showInterstitialAd();
        }
    }

    class C03823 implements OnClickListener {
        C03823() {
        }

        public void onClick(View v) {
            startActivity(new Intent(LudoMainActivity.this, LudoTwoplayerActivity.class));
            showInterstitialAd();

        }
    }

    class C03834 implements OnClickListener {
        C03834() {
        }

        public void onClick(View v) {
          startActivity(new Intent(LudoMainActivity.this, LudoVsCompTwoplayerActivity.class));
          showInterstitialAd();

        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        StaticVariables.initSoundPool(getApplicationContext());
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        setContentView(R.layout.ludo_activity_main);

        BannerAd();
        initAdmobFullAd();
       

        btnMultiplayer =  findViewById(R.id.btnLudoMultiplayer);
        btnMultiplayer.setOnClickListener(new C03801());
        btnVsComputer =  findViewById(R.id.btnLudoVsComp);
        btnVsComputer.setOnClickListener(new C03812());
        btnTwoplayer =findViewById(R.id.btnLudoTwoPlayer);
        btnTwoplayer.setOnClickListener(new C03823());
        btnVsCompTwoplayer = findViewById(R.id.btnLudoVsCompTwoPlayer);
        btnVsCompTwoplayer.setOnClickListener(new C03834());

    }

    private  void BannerAd(){
        mAdView = findViewById(R.id.adView);
        AdRequest adRequest = new AdRequest.Builder().build();
        mAdView.loadAd(adRequest);

    }

    public void initAdmobFullAd() {
        // Initialize the Mobile Ads SDK
        MobileAds.initialize(this, initializationStatus -> {});

        // Load an interstitial ad
        AdRequest adRequest = new AdRequest.Builder().build();
        InterstitialAd.load(this, "your_ad_unit_id", adRequest,
                new InterstitialAdLoadCallback() {
                    @Override
                    public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                        mInterstitialAd = interstitialAd;
                    }

                    @Override
                    public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                        mInterstitialAd = null;
                    }
                });
    }

    // Show the interstitial ad when needed
    public void showInterstitialAd() {
        if (mInterstitialAd != null) {
            mInterstitialAd.show(this);
        }
    }

}
